<?php
header('Content-Type: application/json');

$after = isset($_GET['after']) ? intval($_GET['after']) : 0;
$logFile = 'logs/events_' . date('Y-m-d') . '.json';

if (!file_exists($logFile)) {
    echo json_encode(['events' => []]);
    exit;
}

$events = json_decode(file_get_contents($logFile), true) ?: [];

// Добавляем ID к событиям
foreach ($events as $i => &$event) {
    $event['id'] = $i + 1;
}

// Фильтруем события после у��азанного ID
$newEvents = array_filter($events, function($event) use ($after) {
    return $event['id'] > $after;
});

echo json_encode(['events' => array_values($newEvents)]);
?>